-- new script file

function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
  CreateTriggerSources(self)  
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.pos = self:GetPosition()
    self.p0 = Citadels.GetPlayer(0)
    
    if not self.loaded then
      self.active = false
      self.timer = 4
    end    
    self.reinfTargetReach:LinkToTarget("victory")
  end
  
  if self.active then
    td = Timer:GetTimeDiff()
    self.timer = self.timer - td
  
    if self.timer <= 0 then
      reinfUnits = self.p0:UnitsInRadiusNumberByKey(self.pos, 2500, "p0Reinf")
      Debug:Log("reinfUnits = " .. reinfUnits)
      
			if reinfUnits >= 25 then
        self.p0:WinQuest('D9G_GOAL_3')
        self.reinfTargetReach:TriggerAllTargets()
        self.active = false
      end
			self.timer = 4
    end
  end
end

function OnTrigger(self, source, target)
	if target == "reinfTargetActive" then
    self.active = true
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
    self.active = ar:Read()
    self.timer = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.active)
    ar:Write(self.timer)
  end
end

function CreateTriggerTargets(self)
  self:AddTriggerTarget("reinfTargetActive")
end

function CreateTriggerSources(self)
  self:AddTriggerSource("reinfTargetReach")
end
